;; vlci a ovce jsou rody elv
breed [sheep a-sheep]  ;; sheep je v anglitin pouvno i pro mnon slo, proto 
                       ;; pro jednotn slo pouvme vraz "a-sheep"
breed [wolves wolf]
turtles-own [energy]       ;; vlci i ovce maj energii
patches-own [countdown]

to setup
  clear-all
  ask patches [ set pcolor green ]
  ;; otestuj pepna trava?
  ;; pokud je zapnut (hodnota ON), pak roste trva a ovce j poraj
  ;; pokud je vypnut (hodnota OFF), pak ovce nepotebuj jst
   if trava? [
    ask patches [
      set countdown random interval-obnoveni-travy ;; nastav nhodn intervaly obnovovn trvy na polkch
      set pcolor one-of [green brown]
    ]
  ]
  set-default-shape sheep "sheep"
  create-sheep vychozi-pocet-ovci  ;; vytvo ovce a nastav hodnoty pro jejich promnn
  [
    set color white
    set size 1.5  ;; pro sna viditelnost
    set label-color blue - 2
    set energy random (2 * ovce-vynos-z-potravy)
    setxy random-xcor random-ycor
  ]
  set-default-shape wolves "wolf"
  create-wolves vychozi-pocet-vlku  ;; vytvo vlky a nastav hodnoty pro jejich promnn
  [
    set color black
    set size 1.5  ;; pro sna viditelnost
    set energy random (2 * vlci-vynos-z-potravy)
    setxy random-xcor random-ycor
  ]
  display-labels
  update-plot
end

to go
  if not any? turtles [ stop ]
  ask sheep [
    move
    if trava? [
      set energy energy - 1   ;; odete ovci energii, pokud je zapnut pepna trava? do polohy ON
      eat-grass
    ]
    reproduce-sheep
    death
  ]
  ask wolves [
    move
    set energy energy - 1  ;; vlci ztrc energii pi kadm pohybu
    catch-sheep
    reproduce-wolves
    death
  ]
  if trava? [ ask patches [ grow-grass ] ]
  tick
  update-plot
  display-labels
end

to move  ;; procedura elv
  rt random 50
  lt random 50
  fd 1
end

to eat-grass  ;; procedura ovc
  ;; ovce seere trvu a polko zhndne
  if pcolor = green [
    set pcolor brown
    set energy energy + ovce-vynos-z-potravy  ;; ovce zsk energii sernm trvy
  ]
end

to reproduce-sheep  ;; procedura ovc
  if random-float 100 < reprodukce-ovci [  ;; testovn pravdpodobnosti, zda se ovce rozmno
    set energy (energy / 2)                ;; rozdl energii mezi rodie a potomka
    hatch 1 [ rt random-float 360 fd 1 ]   ;; vytvo potomka a posu jej o 1 krok vped
  ]
end

to reproduce-wolves  ;; procedura vlk
  if random-float 100 < reprodukce-vlku [  ;; testovn pravdpodobnosti, zda se vlk rozmno
    set energy (energy / 2)                ;; rozdl energii mezi rodie a potomka
    hatch 1 [ rt random-float 360 fd 1 ]   ;; vytvo potomka a posu jej o 1 krok vped
  ]
end

to catch-sheep  ;; proedura vlk
  let prey one-of sheep-here                    ;; chytni nhodn jednu z ovc na danm polku
  if prey != nobody                             ;; chytil vlk ovci?  pokud ano,
    [ ask prey [ die ]                          ;; zabij ji
      set energy energy + vlci-vynos-z-potravy ] ;; a zskej energii jejm sernm
end

to death  ;; procedura elv
  ;; pokud ti energie klesne pod nulu, zemi
  if energy < 0 [ die ]
end

to grow-grass  ;; procedura polek
  ;; odpotvn asovch krok do nrstu nov trvy pro hnd 
  ;; polka: pokud se doshne hodnoty 0, vyroste zde dal trva
  if pcolor = brown [
    ifelse countdown <= 0
      [ set pcolor green
        set countdown interval-obnoveni-travy ]
      [ set countdown countdown - 1 ]
  ]
end

to update-plot
  set-current-plot "populace"
  set-current-plot-pen "ovce"
  plot count sheep
  set-current-plot-pen "vlci"
  plot count wolves
  if trava? [
    set-current-plot-pen "trva / 4"
    plot count patches with [pcolor = green] / 4  ;; vydleno tymi, abychom zskali rozmez
                                                  ;; obdobnch hodnot jako u populace vlk a ovc
  ]
end

to display-labels
  ask turtles [ set label "" ]
  if ukazat-energii? [
    ask wolves [ set label round energy ]
    if trava? [ ask sheep [ set label round energy ] ]
  ]
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2000.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo Wolf Sheep Predation model.
; http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1997 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
350
10
819
500
25
25
9.0
1
14
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks

CC-WINDOW
5
523
828
618
Command Center
0

SLIDER
3
150
177
183
vychozi-pocet-ovci
vychozi-pocet-ovci
0
250
100
1
1
NIL
HORIZONTAL

SLIDER
3
187
177
220
ovce-vynos-z-potravy
ovce-vynos-z-potravy
0.0
50.0
4
1.0
1
NIL
HORIZONTAL

SLIDER
3
222
177
255
reprodukce-ovci
reprodukce-ovci
1.0
20.0
4
1.0
1
%
HORIZONTAL

SLIDER
181
150
346
183
vychozi-pocet-vlku
vychozi-pocet-vlku
0
250
50
1
1
NIL
HORIZONTAL

SLIDER
181
186
346
219
vlci-vynos-z-potravy
vlci-vynos-z-potravy
0.0
100.0
20
1.0
1
NIL
HORIZONTAL

SLIDER
181
222
346
255
reprodukce-vlku
reprodukce-vlku
0.0
20.0
5
1.0
1
%
HORIZONTAL

SWITCH
5
87
99
120
trava?
trava?
1
1
-1000

SLIDER
106
88
318
121
interval-obnoveni-travy
interval-obnoveni-travy
0
100
30
1
1
NIL
HORIZONTAL

BUTTON
8
28
79
61
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
90
28
157
61
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
12
312
328
509
populace
time
pop.
0.0
100.0
0.0
100.0
true
true
PENS
"ovce" 1.0 0 -13345367 true
"vlci" 1.0 0 -2674135 true
"trva / 4" 1.0 0 -10899396 true

MONITOR
50
265
121
310
ovce
count sheep
3
1
11

MONITOR
125
265
207
310
vlci
count wolves
3
1
11

MONITOR
211
265
287
310
trva / 4
count patches with [ pcolor = green ] / 4
0
1
11

TEXTBOX
8
130
148
149
Nastaven pro ovce
11
0.0
0

TEXTBOX
186
130
299
148
Nastaven pro vlky
11
0.0
0

TEXTBOX
9
68
161
86
Nastaven pro trvu
11
0.0
0

SWITCH
167
28
307
61
ukazat-energii?
ukazat-energii?
1
1
-1000

@#$#@#$#@
CO TO JE?
-----------
Tento model zkoum stabilitu ekosystmu ve vztahu lovce a koisti. Takovto systm nazvme nestabilnm, pokud m tendenci vystit ve vyhynut jednoho nebo vce uvaovanch ivoinch druh. Naopak stabiln systm je ten, kter je v prbhu asu schopen udrovat sm sebe i navzdory kolsn ve velikosti populac.   

JAK TO FUNGUJE?
------------
Model umouje dv varianty ekosystmu. V prvn variant se pohybuj vlci i ovce nhodn po krajin, piem vlci pi setkn s ovc zato na svou koist a seerou ji. Kad krok stoj vlky energii, kterou dopluj pornm ovc. Pokud vlk pln vyerp svou energii, zeme. Aby mohla populace petrvat, kad vlk i kad ovce maj pevn stanovenou pravdpodobnost reprodukce v kadm kole modelu. Tato varianta vykazuje zajmavou populan dynamiku, celkov je vak nestabiln.

Druh varianta krom ovc a vlk zaleuje do modelu tak trvu. Chovn vlk je stejn jako v  pedchozm ppad, avak ovce mus spsat trvu, aby obnovily svou energii -  pokud dojde ovci energie, pak umr. Trva po spasen opt po jistm pevn stanovm ase dorst. Tato varianta je vce komplexn ne pedel a je celkov stabiln.

Sestaven tohoto modelu je popsno ve dvou lncch Wilensky & Reisman, uvedench dle v odkazech.  

JAK MODEL OVLDAT?
-------------
- nastavte pepna TRVA? do polohy ON k zalenn trvy do modelu, nebo do polohy OFF, aby model obsahoval pouze vlky (ern) a ovce (bl).
- pizpsobte nastaven jednotlivch parametr (viz ne), nebo pouijte pvodn nastaven.
- kliknte na tlatko PIPRAV.
- kliknutm na tlatko START spuste simulaci.
- sledujte jednotliv ukazatele aktuln velikosti jednotlivch populac.
- sledujte graf POPULACE, ve kterm je vykreslovno kolsn populac v ase.  

Parametry:
VYCHOZI-POCET-OVCI: Vchoz velikost populace ovc.
VYCHOZI-POCET-VLKU: Vchoz velikost populace vlk.
OVCE-VYNOS-Z-POTRAVY: Mnostv energie, kter zsk ovce spasenm jednoho polka trvy.
VLCI-VYNOS-Z-POTRAVY: Mnostv energie, kter zsk vlk sernm uloven ovce.
REPRODUKCE-OVCI: Pravdpodobnost s jakou se ovce v kadm kole simulace me rozmnoit.
REPRODUKCE-VLKU: Pravdpodobnost s jakou se vlk v kadm kole simulace me rozmnoit.
TRAVA?: Vypn a zapn ptomnost trvy v modelu.
INTERVAL-OBNOVENI-TRAVY: Doba, za kterou trva znovu vyroste od okamiku, kdy je spasena.
UKAZAT-ENERGII: Vypn a zapn seln ukazatel energie u vech zvat.

Poznmky:
- vlkm je pi kadm kroku odetena jednotka energie
- pokud je v modelu zahrnuta trva, pak je i ovcm pi kadm kroku odetena jednotka energie 

VIMNTE SI
----------------
Sledujte populan vkyvy v situaci, kdy nen do modelu zalenna ptomnost trvy. Povimnte si, e vzestupy i poklesy jednotlivch populac jsou ve vzjemnm vztahu. Jak byste tento vztah popsali? Co se nakonec stane?

Pokud je do modelu zahrnuta trva, vykresluje se jej mnostv v grafu zelenou barvou. Jakm zpsobem se nyn tyto ti populace vzjemn ovlivuj? Jak byste toto chovn vysvtlili?

Pro jsou podle vs nkter varianty tohoto modelu stabiln, zatmco jin nikoliv?

ZKUSTE SI
-------------
Experimentujte s rznmi hodnotami uvedench parametr. Nakolik je stabilita modelu citliv na jednotliv parametry?

Je mon nalzt parametry, kter by vytvely stabiln ekosystm, obsahujc pouze vlky a ovce?

Nastavte pepna TRAVA? na hodnotu ON (zapnuto), k tomu vak snite hodnotu VYCHOZI-POCET-VLKU na 0. Tak vznikne stabiln ekosystm, obsahujc pouze trvu a ovce. Z jakho dvodu me bt tento systm stabiln ve srovnn s variantou obsahujc pouze vlky a ovce, kter tohoto vyrovnanho stavu nedoshne? 

Vimnte si, e u stabilnch ekosystm populace kolsaj v pravidelnch pedpovdatelnch cyklech. Dokete najt parametr, kter by tento cyklus urychloval nebo zkracoval?

Zkuste zmnit pravidla pro reprodukci - co by se napklad stalo, pokud by rozmnoovn bylo zvisl na mnostv energie a nikoliv na pevn dan pravdpodobnosti?


ROZEN MODELU
-------------------
Existuje vce monost, jak upravit model tak, aby vykazoval stabiln chovn s ekosystmem obsahujcm pouze vlky a ovce (bez trvy). Nkter z tchto monost vyaduj zaveden novch prvk do kdu programu nebo zmnu dosavadnch pravidel chovn. Dokete vyvinout takto upravenou verzi?


PROGRAMOVAC ZAJMAVOSTI NETLOGA
----------------
Vimnte si, e jsou zde pouity dva odlin rody (breeds) k modelovn rznch druh elv (turtles): vlci a ovce. Polka (patches) jsou pouita k modelovn trvy.

Vyuit primitiva ONE-OF slou k nhodnmu vbru ovce (pokud jich je na polku s vlkem vce), kter m bt serna. 

SOUVISEJC MODELY
---------------
Podvejte se na model Rabbits Grass Weeds (Krlci, trva a plevel) v knihovn NetLoga. Jedn se o dal model vzjemn se ovlivujcch populac s odlinmi pravidly chovn.


PODKOVN A ODKAZY
----------------------
Wilensky, U. & Reisman, K. (1999). Connected Science: Learning Biology through Constructing and Testing Computational Theories -- an Embodied Modeling Approach. International Journal of Complex Systems, M. 234, strany 1 - 12. (Tento model je mrn rozenou verz modelu, popsanho v uveden literatue.)

Wilensky, U. & Reisman, K. Thinking like a Wolf, a Sheep or a Firefly: Learning Biology through Constructing and Testing Computational Theories -- an Embodied Modeling Approach. Cognition & Instruction.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (1997). NetLogo Wolf Sheep Predation model.  http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1997 Uri Wilensky.  All rights reserved.  
Pro dal informace viz  http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -16777216 true false 166 225 195 285
Rectangle -16777216 true false 62 225 90 285
Rectangle -7500403 true true 30 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 180 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Rectangle -7500403 true true 195 106 285 150
Rectangle -7500403 true true 195 90 255 105
Polygon -7500403 true true 240 90 217 44 196 90
Polygon -16777216 true false 234 89 218 59 203 89
Rectangle -1 true false 240 93 252 105
Rectangle -16777216 true false 242 96 249 104
Rectangle -16777216 true false 241 125 285 139
Polygon -1 true false 285 125 277 138 269 125
Polygon -1 true false 269 140 262 125 256 140
Rectangle -7500403 true true 45 120 195 195
Rectangle -7500403 true true 45 114 185 120
Rectangle -7500403 true true 165 195 180 270
Rectangle -7500403 true true 60 195 75 270
Polygon -7500403 true true 45 105 15 30 15 75 45 150 60 120

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
setup
set grass? true
repeat 75 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
